(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79942,       1934]
NotebookOptionsPosition[     77857,       1887]
NotebookOutlinePosition[     78254,       1903]
CellTagsIndexPosition[     78211,       1900]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Equidiagonal  Quadrilaterals - vertex centroid", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 3.947144443366682*^9}, {3.947339713636549*^9, 
  3.947339717251663*^9}, {3.954728574674156*^9, 3.954728576840864*^9}, {
  3.9547551538092937`*^9, 
  3.9547551637131233`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about equidiagonal \
quadrilaterals in the paper \[OpenCurlyDoubleQuote]More Shapes of Central \
Quadrilaterals\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
  3.947339725299139*^9, 3.947339727179648*^9}, {3.954754697225456*^9, 
  3.954754702049347*^9}, {3.961113806321228*^9, 3.9611138072622375`*^9}, {
  3.961412331248707*^9, 
  3.961412337680407*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptD", "=", 
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], ";"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"condition", " ", "for", " ", "equidiagonal", " ", "quad"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"equi", "=", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"u", "==", "b"}], ",", 
      RowBox[{
       RowBox[{"u", "^", "2"}], "==", 
       RowBox[{"CuadradoDistancia", "[", 
        RowBox[{"ptB", ",", "ptD"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", "u", "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471447897267284`*^9, 3.9471448143356647`*^9}, {3.947339795568245*^9, 
   3.9473398095558796`*^9}, {3.954728590165919*^9, 3.954728595103447*^9}, {
   3.954754762087368*^9, 3.9547547840188313`*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["p", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SuperscriptBox["p", "2"]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["q", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["r", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["r", "2"]}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{3.9547547921793613`*^9, 3.95475507942309*^9, 
  3.961113885133213*^9, 3.961412348240117*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"dda35798-d16b-4d69-8d82-ce8afeba2ed3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"8108185d-0476-624f-aca1-\
9531401fcf8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "vertex", " ", "centroid", " ", "of", " ", "a", " ", "quadrilateral"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centroidQuad", "[", 
      RowBox[{"{", 
       RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
     RowBox[{"Punto", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{
         RowBox[{"Medio", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Medio", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Recta", "[", 
        RowBox[{
         RowBox[{"Medio", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Medio", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "tests", " ", "for", " ", "parallelism", " ", "and", " ", 
     "perpendicularity"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinito", "[", "r", "]"}], ".", "s"}], "]"}], "/.", 
         "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"perpendicularQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinitoPerpendicular", "[", 
            RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}], ".", "s"}], 
          "]"}], "/.", "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", " ", "orthodiagonal", " ", "quadrilateral"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"orthodiagonalQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"perpendicularQ", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P", ",", "R"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q", ",", "S"}], "]"}], ",", "cond"}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
   3.947133479684403*^9, 3.947133480044634*^9}, {3.954749394336471*^9, 
   3.954749396294033*^9}, {3.954750090329485*^9, 3.954750131865982*^9}, {
   3.954753612330324*^9, 3.954753613564296*^9}, 3.954753651040304*^9, {
   3.954753717466011*^9, 3.9547537696116104`*^9}, 3.954753823286117*^9, {
   3.9547539533955135`*^9, 3.954754007724783*^9}, {3.954754908348152*^9, 
   3.954754934396097*^9}, {3.9547585245539*^9, 3.954758530897945*^9}, {
   3.961114077723961*^9, 3.9611141111734905`*^9}, {3.9611141665046425`*^9, 
   3.9611141889774876`*^9}, {3.9611142557469864`*^9, 3.9611142836663666`*^9}, 
   3.961412474082666*^9},
 CellLabel->
  "In[105]:=",ExpressionUUID->"af857665-e69b-be41-831b-79c8778d303b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQlcVOX+/wf/5fK6c+1P9+pP79W0uJiXn2ZBlpgVZIpLSJq4EO47pIb7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    "], {{0, 99.84905660377358}, {667.6981132075472, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{667.6981132075472, 99.84905660377358},
  PlotRange->{{0, 667.6981132075472}, {0, 99.84905660377358}}]], "Text",
 CellChangeTimes->{
  3.9547289833023987`*^9},ExpressionUUID->"27562332-302c-684c-a6e9-\
c7f5988655e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptE", "=", 
  RowBox[{"centroidQuad", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"vertex", " ", "centroid", " ", "of", " ", "ABCD"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.954729517411064*^9, 3.954729545606804*^9}, {
  3.954754889196739*^9, 3.954754892674591*^9}, {3.954755094602075*^9, 
  3.9547551086826744`*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"92df2acf-ef77-6d4c-a144-72124269f2b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "p"}], "-", "q", "-", "r"}], ",", 
   RowBox[{
    RowBox[{"-", "p"}], "-", 
    RowBox[{"2", " ", "q"}], "-", "r"}], ",", 
   RowBox[{
    RowBox[{"-", "p"}], "-", "q", "-", 
    RowBox[{"2", " ", "r"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.954729538170908*^9, 3.954729546305495*^9}, 
   3.954731754861231*^9, 3.9547551099596972`*^9, 3.961114133301407*^9, 
   3.96141238306748*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"2476b26f-12b5-4674-bc2f-edc5437e540e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["X (591)", "Subsection",
 CellChangeTimes->{{3.9547317438609138`*^9, 
  3.954731748709286*^9}},ExpressionUUID->"ecf6dcd3-cf0e-b645-870d-\
ac275961074f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"centralQuadrilateral", "[", 
   RowBox[{"591", ",", "ptE"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.954729571311468*^9, 3.9547296004388103`*^9}, {
  3.954754997771496*^9, 3.954754997798126*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"ef7de7f6-c2df-024e-ac07-6e9790b96d26"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "3"]}], "-", 
      RowBox[{"37", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "3"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "r"}], "-", 
      RowBox[{"50", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r"}], "-", 
      RowBox[{"61", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "r"}], "-", 
      RowBox[{"13", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"50", " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"13", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["r", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"35", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"94", " ", "q", " ", "r"}], "+", 
            RowBox[{"59", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"49", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "+", 
         RowBox[{"63", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"26", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"37", " ", "q"}], "+", 
            RowBox[{"49", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"37", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"100", " ", "q", " ", "r"}], "+", 
            RowBox[{"63", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["p", "3"], " ", "S"}], "-", 
      RowBox[{"68", " ", 
       SuperscriptBox["p", "2"], " ", "q", " ", "S"}], "-", 
      RowBox[{"64", " ", "p", " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "-", 
      RowBox[{"20", " ", 
       SuperscriptBox["q", "3"], " ", "S"}], "-", 
      RowBox[{"92", " ", 
       SuperscriptBox["p", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"172", " ", "p", " ", "q", " ", "r", " ", "S"}], "-", 
      RowBox[{"80", " ", 
       SuperscriptBox["q", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"108", " ", "p", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"100", " ", "q", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"40", " ", 
       SuperscriptBox["r", "3"], " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "24"}], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "3"]}], "-", 
      RowBox[{"37", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "q"}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "3"]}], "-", 
      RowBox[{"61", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "r"}], "-", 
      RowBox[{"50", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r"}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "r"}], "-", 
      RowBox[{"50", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"13", " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"13", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["r", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "+", 
         RowBox[{"59", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"22", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"35", " ", "q"}], "+", 
            RowBox[{"44", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"36", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"94", " ", "q", " ", "r"}], "+", 
            RowBox[{"55", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"49", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "+", 
         RowBox[{"63", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"26", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"37", " ", "q"}], "+", 
            RowBox[{"49", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"37", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"100", " ", "q", " ", "r"}], "+", 
            RowBox[{"63", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"20", " ", 
       SuperscriptBox["p", "3"], " ", "S"}], "-", 
      RowBox[{"64", " ", 
       SuperscriptBox["p", "2"], " ", "q", " ", "S"}], "-", 
      RowBox[{"68", " ", "p", " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["q", "3"], " ", "S"}], "-", 
      RowBox[{"80", " ", 
       SuperscriptBox["p", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"172", " ", "p", " ", "q", " ", "r", " ", "S"}], "-", 
      RowBox[{"92", " ", 
       SuperscriptBox["q", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"100", " ", "p", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"108", " ", "q", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"40", " ", 
       SuperscriptBox["r", "3"], " ", "S"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "q", "+", 
          RowBox[{"2", " ", "r"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"12", " ", 
              SuperscriptBox["p", "2"]}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox["q", "2"]}], "+", 
             RowBox[{"25", " ", "q", " ", "r"}], "+", 
             RowBox[{"13", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"25", " ", "p", " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "S"}]}], 
            ")"}]}]}], ")"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"13", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"25", " ", "q", " ", "r"}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"25", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "S"}]}], 
          ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"13", " ", 
          SuperscriptBox["p", "3"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"37", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"13", " ", "q"}], "+", 
            RowBox[{"50", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"50", " ", "q", " ", "r"}], "+", 
            RowBox[{"61", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"24", " ", "p", " ", "q"}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"22", " ", "p", " ", "r"}], "+", 
            RowBox[{"24", " ", "q", " ", "r"}], "+", 
            RowBox[{"11", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"13", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"25", " ", "q", " ", "r"}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"25", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"11", " ", "p", " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"10", " ", "p", " ", "r"}], "+", 
            RowBox[{"11", " ", "q", " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"13", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"37", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"50", " ", "q"}], "+", 
            RowBox[{"13", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"61", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"50", " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"22", " ", "p", " ", "q"}], "+", 
            RowBox[{"11", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"24", " ", "p", " ", "r"}], "+", 
            RowBox[{"24", " ", "q", " ", "r"}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"13", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"25", " ", "q", " ", "r"}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"25", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"10", " ", "p", " ", "q"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"11", " ", "p", " ", "r"}], "+", 
            RowBox[{"11", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "S"}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "3"]}], "-", 
      RowBox[{"23", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "r"}], "-", 
      RowBox[{"22", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["r", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "-", 
         RowBox[{"3", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"23", " ", "q"}], "+", 
            RowBox[{"11", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"23", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"44", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["p", "3"]}], "-", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"23", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"22", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["p", "3"], " ", "S"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["p", "2"], " ", "q", " ", "S"}], "+", 
      RowBox[{"24", " ", "p", " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["q", "3"], " ", "S"}], "-", 
      RowBox[{"28", " ", 
       SuperscriptBox["p", "2"], " ", "r", " ", "S"}], "+", 
      RowBox[{"20", " ", "p", " ", "q", " ", "r", " ", "S"}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["q", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"4", " ", "p", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "+", 
      RowBox[{"4", " ", "q", " ", 
       SuperscriptBox["r", "2"], " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "23"}], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "q"}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "r"}], "-", 
      RowBox[{"22", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r"}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "r"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "q", " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["r", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "-", 
         RowBox[{"3", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"23", " ", "q"}], "+", 
            RowBox[{"11", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"23", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"44", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "3"], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "+", 
         RowBox[{"q", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "23"}], " ", "q"}], "+", 
            RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "36"}], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"22", " ", "q", " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["p", "3"], " ", "S"}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["p", "2"], " ", "q", " ", "S"}], "+", 
      RowBox[{"4", " ", "p", " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["q", "3"], " ", "S"}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["p", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"20", " ", "p", " ", "q", " ", "r", " ", "S"}], "+", 
      RowBox[{"28", " ", 
       SuperscriptBox["q", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"4", " ", "p", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "+", 
      RowBox[{"4", " ", "q", " ", 
       SuperscriptBox["r", "2"], " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "3"]}], "+", 
      RowBox[{"23", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "q"}], "+", 
      RowBox[{"23", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "3"]}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "r"}], "+", 
      RowBox[{"44", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r"}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "r"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["r", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"59", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "-", 
         RowBox[{"4", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"46", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"59", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"66", " ", "q", " ", "r"}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"24", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "-", 
         RowBox[{"8", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"59", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"46", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"66", " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"20", " ", 
       SuperscriptBox["p", "3"], " ", "S"}], "-", 
      RowBox[{"20", " ", 
       SuperscriptBox["p", "2"], " ", "q", " ", "S"}], "+", 
      RowBox[{"20", " ", "p", " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["q", "3"], " ", "S"}], "-", 
      RowBox[{"60", " ", 
       SuperscriptBox["p", "2"], " ", "r", " ", "S"}], "+", 
      RowBox[{"60", " ", 
       SuperscriptBox["q", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"40", " ", "p", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "+", 
      RowBox[{"40", " ", "q", " ", 
       SuperscriptBox["r", "2"], " ", "S"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "3"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "q"}], "-", 
      RowBox[{"59", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "3"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "r"}], "-", 
      RowBox[{"66", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r"}], "-", 
      RowBox[{"59", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "r"}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"46", " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"11", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["r", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"23", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "+", 
         RowBox[{"23", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"11", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", "q"}], "+", 
            RowBox[{"24", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"66", " ", "q", " ", "r"}], "+", 
            RowBox[{"59", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"40", " ", 
       SuperscriptBox["p", "2"], " ", "q", " ", "S"}], "+", 
      RowBox[{"60", " ", "p", " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["q", "3"], " ", "S"}], "-", 
      RowBox[{"40", " ", 
       SuperscriptBox["p", "2"], " ", "r", " ", "S"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["q", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"60", " ", "p", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"20", " ", "q", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"20", " ", 
       SuperscriptBox["r", "3"], " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "q"}], "+", 
      RowBox[{"48", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "3"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "r"}], "+", 
      RowBox[{"22", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r"}], "+", 
      RowBox[{"36", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "r"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{"23", " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["r", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "3"], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "-", 
         RowBox[{"23", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"22", " ", "q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "3"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"23", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "+", 
         RowBox[{"23", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"11", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["p", "2"], " ", "q", " ", "S"}], "+", 
      RowBox[{"28", " ", "p", " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["q", "3"], " ", "S"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["p", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"20", " ", "p", " ", "q", " ", "r", " ", "S"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["q", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"8", " ", "p", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"24", " ", "q", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["r", "3"], " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "q"}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["p", "2"], " ", "r"}], "+", 
      RowBox[{"44", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r"}], "+", 
      RowBox[{"23", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "r"}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{"23", " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["r", "3"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "3"]}], "+", 
         SuperscriptBox["q", "3"], "-", 
         RowBox[{"23", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "-", 
         RowBox[{"36", " ", "q", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"22", " ", "q", " ", "r"}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "3"], "-", 
         RowBox[{"23", " ", 
          SuperscriptBox["q", "2"], " ", "r"}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["q", "2"], "-", 
            RowBox[{"22", " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["p", "2"], " ", "q", " ", "S"}], "+", 
      RowBox[{"8", " ", "p", " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["q", "3"], " ", "S"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["p", "2"], " ", "r", " ", "S"}], "+", 
      RowBox[{"20", " ", "p", " ", "q", " ", "r", " ", "S"}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["q", "2"], " ", "r", " ", "S"}], "-", 
      RowBox[{"28", " ", "p", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"4", " ", "q", " ", 
       SuperscriptBox["r", "2"], " ", "S"}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["r", "3"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.954729575891878*^9, 3.9547296012302666`*^9}, 
   3.954729646954029*^9, 3.954731759231823*^9, 3.954755116825212*^9, 
   3.9611141410919*^9, 3.961412392338933*^9, 3.9614124855746717`*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"4161b4dc-663b-4331-b0ad-2836fbea6ff5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"orthodiagonalQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", "equi"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.954729807859654*^9, 3.954729824503559*^9}, {
   3.954755009211235*^9, 3.954755013394407*^9}, {3.9547550467536907`*^9, 
   3.954755057026333*^9}, {3.954755133083036*^9, 3.9547551347750807`*^9}, 
   3.961114242297739*^9},
 CellLabel->
  "In[116]:=",ExpressionUUID->"17b3a835-0e2e-9e4e-8891-bb03c169344a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.954755124252447*^9, 3.954755136469471*^9}, 
   3.9611141470682144`*^9, 3.961114197164707*^9, 3.961114245413992*^9, 
   3.9614124080340223`*^9, 3.961412493202668*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"dd79fa54-33e7-4b4d-8c07-3c19bc808001"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1435, 1125},
WindowMargins->{{253, Automatic}, {Automatic, 92}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2c987011-4232-1444-860d-88047ca04ba6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 386, 6, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[969, 30, 1528, 26, 164, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2522, 60, 200, 4, 66, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[CellGroupData[{
Cell[2747, 68, 2027, 47, 131, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],
Cell[4777, 117, 1061, 30, 33, "Output",ExpressionUUID->"dda35798-d16b-4d69-8d82-ce8afeba2ed3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5887, 153, 255, 4, 66, "Section",ExpressionUUID->"8108185d-0476-624f-aca1-9531401fcf8c"],
Cell[6145, 159, 7789, 211, 503, "Input",ExpressionUUID->"af857665-e69b-be41-831b-79c8778d303b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13971, 375, 211, 4, 66, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[14185, 381, 23333, 388, 114, "Text",ExpressionUUID->"27562332-302c-684c-a6e9-c7f5988655e4"],
Cell[CellGroupData[{
Cell[37543, 773, 515, 12, 29, "Input",ExpressionUUID->"92df2acf-ef77-6d4c-a144-72124269f2b6"],
Cell[38061, 787, 567, 16, 33, "Output",ExpressionUUID->"2476b26f-12b5-4674-bc2f-edc5437e540e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38665, 808, 157, 3, 53, "Subsection",ExpressionUUID->"ecf6dcd3-cf0e-b645-870d-ac275961074f"],
Cell[CellGroupData[{
Cell[38847, 815, 399, 9, 29, "Input",ExpressionUUID->"ef7de7f6-c2df-024e-ac07-6e9790b96d26"],
Cell[39249, 826, 37712, 1032, 512, "Output",ExpressionUUID->"4161b4dc-663b-4331-b0ad-2836fbea6ff5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76998, 1863, 502, 11, 29, "Input",ExpressionUUID->"17b3a835-0e2e-9e4e-8891-bb03c169344a"],
Cell[77503, 1876, 302, 5, 33, "Output",ExpressionUUID->"dd79fa54-33e7-4b4d-8c07-3c19bc808001"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

